implementation module controlpos


//	Clean Object I/O library version 1.0.1

import oswindow
import commondef, windowaccess, windowclipstate, wstateaccess


controlposFatalError :: String String -> .x
controlposFatalError function error
	= FatalError function "controlpos" error


/*	movecontrolspos` moves every WElementHandle` by the given Vector which layout attribute is 
	Fix Point or depends on such an item. 
	The OSWindowPtr argument identifies the parent window.
	The Point argument is the position of the parent component (zero in case of top level controls). 
*/
movecontrolspos` :: !Vector !OSWindowPtr !Point ![WElementHandle`] !*OSToolbox -> (![WElementHandle`],!*OSToolbox)
movecontrolspos` v wPtr parentPos itemHs tb
	= StateMap (movecontrolpos True v wPtr parentPos) itemHs tb
where
	movecontrolpos :: !Bool !Vector !OSWindowPtr !Point !WElementHandle` !*OSToolbox -> (!WElementHandle`,!*OSToolbox)
	movecontrolpos moveItems v wPtr parentPos (WRecursiveHandle` itemHs wKind) tb
		# (itemHs,tb)	= StateMap (movecontrolpos moveItems v wPtr parentPos) itemHs tb
		= (WRecursiveHandle` itemHs wKind,tb)
	movecontrolpos moveItems v wPtr parentPos (WItemHandle` itemH=:{wItemFixedPos`}) tb
		| not wItemFixedPos`
		= (WItemHandle` itemH,tb)
		# (itemH,tb)	= movecontrol moveItems v wPtr parentPos itemH tb
		= (WItemHandle` itemH,tb)
	where
		movecontrol :: !Bool !Vector !OSWindowPtr !Point !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
		movecontrol moveItems v wPtr parentPos itemH=:{wItemKind`=IsRadioControl} tb
			# (items,tb)	= StateMap (moveradiocontrol moveItems v wPtr (PointToTuple parentPos)) radioItems tb
			  info			= {info & radioItems`=items}
			  itemH			= {itemH & wItemPos`=newPos,wItemInfo`=RadioInfo` info}
			= (itemH,tb)
		where
			info			= getWItemRadioInfo` itemH.wItemInfo`
			radioItems		= info.radioItems`
			newPos			= addPointVector v itemH.wItemPos`
			
			moveradiocontrol :: !Bool !Vector !OSWindowPtr !(!Int,!Int) !RadioItemInfo` !*OSToolbox -> (!RadioItemInfo`,!*OSToolbox)
			moveradiocontrol moveItems v wPtr parentPos itemH=:{radioItemPos`,radioItemSize`,radioItemPtr`} tb
				| not moveItems
				= (itemH1,tb)
				= (itemH1,OSsetRadioControlPos wPtr parentPos radioItemPtr` (PointToTuple newPos) (SizeToTuple radioItemSize`) tb)
			where
				newPos		= addPointVector v radioItemPos`
				itemH1		= {itemH & radioItemPos`=newPos}
		
		movecontrol moveItems v wPtr parentPos itemH=:{wItemKind`=IsCheckControl} tb
			# (items,tb)	= StateMap (movecheckcontrol moveItems v wPtr (PointToTuple parentPos)) checkItems tb
			  info			= {info & checkItems`=items}
			  itemH			= {itemH & wItemPos`=newPos,wItemInfo`=CheckInfo` info}
			= (itemH,tb)
		where
			info			= getWItemCheckInfo` itemH.wItemInfo`
			checkItems		= info.checkItems`
			newPos			= addPointVector v itemH.wItemPos`
			
			movecheckcontrol :: !Bool !Vector !OSWindowPtr !(!Int,!Int) !CheckItemInfo` !*OSToolbox -> (!CheckItemInfo`,!*OSToolbox)
			movecheckcontrol moveItems v wPtr parentPos itemH=:{checkItemPos`,checkItemSize`,checkItemPtr`} tb
				| not moveItems
				= (itemH1,tb)
				= (itemH1,OSsetCheckControlPos wPtr parentPos checkItemPtr` (PointToTuple newPos) (SizeToTuple checkItemSize`) tb)
			where
				newPos		= addPointVector v checkItemPos`
				itemH1		= {itemH & checkItemPos`=newPos}
		
		movecontrol _ v wPtr parentPos itemH=:{wItemKind`=IsCompoundControl} tb
			# (moveItems,tb)= OSsetCompoundPos wPtr (PointToTuple parentPos) itemH.wItemPtr` (PointToTuple newPos) (SizeToTuple itemH.wItemSize`) tb
			# (itemHs,tb)	= StateMap (movecontrolpos moveItems v wPtr newPos) itemH.wItems` tb
			  info			= {	info & compoundHScroll=moveslider v info.compoundHScroll
									 , compoundVScroll=moveslider v info.compoundVScroll
							  }
			  itemH			= {itemH & wItemPos`=newPos,wItems`=itemHs,wItemInfo`=CompoundInfo` info}
			  itemH			= invalidateCompoundClipState` itemH
			= (itemH,tb)
		where
			info			= getWItemCompoundInfo` itemH.wItemInfo`
			itemPos			= itemH.wItemPos`
			newPos			= addPointVector v itemPos
			
			moveslider :: !Vector !(Maybe ScrollInfo) -> Maybe ScrollInfo
			moveslider v (Just info=:{scrollItemPos})
				= Just {info & scrollItemPos=addPointVector v scrollItemPos}
			moveslider _ scrollInfo
				= scrollInfo
		
		movecontrol moveItems v wPtr parentPos itemH=:{wItemKind`} tb
			| not moveItems
			= (itemH1,tb)
			= (itemH1,osAction wPtr (PointToTuple parentPos) itemH.wItemPtr` (PointToTuple newPos) (SizeToTuple itemH.wItemSize`) tb)
		where
			newPos			= addPointVector v itemH.wItemPos`
			itemH1			= {itemH & wItemPos`=newPos}
			osAction		= case wItemKind` of
								IsPopUpControl			-> OSsetPopUpControlPos
								IsSliderControl			-> OSsetSliderControlPos
								IsTextControl			-> OSsetTextControlPos
								IsEditControl			-> OSsetEditControlPos
								IsButtonControl			-> OSsetButtonControlPos
								IsCustomButtonControl	-> OSsetCustomButtonControlPos
								IsCustomControl			-> OSsetCustomControlPos
								(IsOtherControl _)		-> \_ _ _ _ _ tb -> tb
								_						-> controlposFatalError "movecontrolspos`" "unexpected ControlKind alternative"


/*	movecontrolspos moves every WElementHandle by the given Vector. 
	The OSWindowPtr argument identifies the parent window.
*/
movecontrolspos :: !Vector !OSWindowPtr !Point ![WElementHandle .ls .ps] !*OSToolbox -> (![WElementHandle .ls .ps],!*OSToolbox)
movecontrolspos v wPtr parentPos itemHs tb
	= StateMap (movecontrolpos True v wPtr parentPos) itemHs tb
where
	movecontrolpos :: !Bool !Vector !OSWindowPtr !Point !(WElementHandle .ls .ps) !*OSToolbox -> (!WElementHandle .ls .ps,!*OSToolbox)
	movecontrolpos moveItems v wPtr parentPos (WListLSHandle itemHs) tb
		# (itemHs,tb)	= StateMap (movecontrolpos moveItems v wPtr parentPos) itemHs tb
		= (WListLSHandle itemHs,tb)
	movecontrolpos moveItems v wPtr parentPos (WExtendLSHandle wExH=:{wExtendItems=itemHs}) tb
		# (itemHs,tb)	= StateMap (movecontrolpos moveItems v wPtr parentPos) itemHs tb
		= (WExtendLSHandle {wExH & wExtendItems=itemHs},tb)
	movecontrolpos moveItems v wPtr parentPos (WChangeLSHandle wChH=:{wChangeItems=itemHs}) tb
		# (itemHs,tb)	= StateMap (movecontrolpos moveItems v wPtr parentPos) itemHs tb
		= (WChangeLSHandle {wChH & wChangeItems=itemHs},tb)
	movecontrolpos moveItems v wPtr parentPos (WItemHandle itemH=:{wItemFixedPos}) tb
		| not wItemFixedPos
		= (WItemHandle itemH,tb)
		# (itemH,tb)	= movecontrol moveItems v wPtr parentPos itemH tb
		= (WItemHandle itemH,tb)
	where
		movecontrol :: !Bool !Vector !OSWindowPtr !Point !(WItemHandle .ls .ps) !*OSToolbox -> (!WItemHandle .ls .ps,!*OSToolbox)
		movecontrol moveItems v wPtr parentPos itemH=:{wItemKind=IsRadioControl} tb
			# (items,tb)	= StateMap (moveradiocontrol moveItems v wPtr (PointToTuple parentPos)) radioItems tb
			  info			= {info & radioItems=items}
			  itemH			= {itemH & wItemPos=newPos,wItemInfo=RadioInfo info}
			= (itemH,tb)
		where
			info			= getWItemRadioInfo itemH.wItemInfo
			radioItems		= info.radioItems
			newPos			= addPointVector v itemH.wItemPos
			
			moveradiocontrol :: !Bool !Vector !OSWindowPtr !(!Int,!Int) !(RadioItemInfo .ps) !*OSToolbox -> (!RadioItemInfo .ps,!*OSToolbox)
			moveradiocontrol moveItems v wPtr parentPos itemH=:{radioItemPos,radioItemSize,radioItemPtr} tb
				| not moveItems
				= (itemH1,tb)
				= (itemH1,OSsetRadioControlPos wPtr parentPos radioItemPtr (PointToTuple newPos) (SizeToTuple radioItemSize) tb)
			where
				newPos		= addPointVector v radioItemPos
				itemH1		= {itemH & radioItemPos=newPos}
		
		movecontrol moveItems v wPtr parentPos itemH=:{wItemKind=IsCheckControl} tb
			# (items,tb)	= StateMap (movecheckcontrol moveItems v wPtr (PointToTuple parentPos)) checkItems tb
			  info			= {info & checkItems=items}
			  itemH			= {itemH & wItemPos=newPos,wItemInfo=CheckInfo info}
			= (itemH,tb)
		where
			info			= getWItemCheckInfo itemH.wItemInfo
			checkItems		= info.checkItems
			newPos			= addPointVector v itemH.wItemPos
			
			movecheckcontrol :: !Bool !Vector !OSWindowPtr !(!Int,!Int) !(CheckItemInfo .ps) !*OSToolbox -> (!CheckItemInfo .ps,!*OSToolbox)
			movecheckcontrol moveItems v wPtr parentPos itemH=:{checkItemPos,checkItemSize,checkItemPtr} tb
				| not moveItems
				= (itemH1,tb)
				= (itemH1,OSsetCheckControlPos wPtr parentPos checkItemPtr (PointToTuple newPos) (SizeToTuple checkItemSize) tb)
			where
				newPos		= addPointVector v checkItemPos
				itemH1		= {itemH & checkItemPos=newPos}
		
		movecontrol _ v wPtr parentPos itemH=:{wItemKind=IsCompoundControl} tb
			# (moveItems,tb)= OSsetCompoundPos wPtr (PointToTuple parentPos) itemH.wItemPtr (PointToTuple newPos) (SizeToTuple itemH.wItemSize) tb
			# (itemHs,tb)	= StateMap (movecontrolpos moveItems v wPtr newPos) itemH.wItems tb
			  info			= {	info & compoundHScroll=moveslider v info.compoundHScroll
									 , compoundVScroll=moveslider v info.compoundVScroll
							  }
			  itemH			= {itemH & wItemPos=newPos,wItems=itemHs,wItemInfo=CompoundInfo info}
			  itemH			= invalidateCompoundClipState itemH
			= (itemH,tb)
		where
			info			= getWItemCompoundInfo itemH.wItemInfo
			itemPos			= itemH.wItemPos
			newPos			= addPointVector v itemPos
			
			moveslider :: !Vector !(Maybe ScrollInfo) -> Maybe ScrollInfo
			moveslider v (Just info=:{scrollItemPos})
				= Just {info & scrollItemPos=addPointVector v scrollItemPos}
			moveslider _ scrollInfo
				= scrollInfo
		
		movecontrol moveItems v wPtr parentPos itemH=:{wItemKind} tb
			| not moveItems
			= (itemH1,tb)
			= (itemH1,osAction wPtr (PointToTuple parentPos) itemH.wItemPtr (PointToTuple newPos) (SizeToTuple itemH.wItemSize) tb)
		where
			newPos			= addPointVector v itemH.wItemPos
			itemH1			= {itemH & wItemPos=newPos}
			osAction		= case wItemKind of
								IsPopUpControl			-> OSsetPopUpControlPos
								IsSliderControl			-> OSsetSliderControlPos
								IsTextControl			-> OSsetTextControlPos
								IsEditControl			-> OSsetEditControlPos
								IsButtonControl			-> OSsetButtonControlPos
								IsCustomButtonControl	-> OSsetCustomButtonControlPos
								IsCustomControl			-> OSsetCustomControlPos
								(IsOtherControl _)		-> \_ _ _ _ _ tb -> tb
								_						-> controlposFatalError "movecontrolspos" "unexpected ControlKind alternative"
